$(document).ready(function () {
  console.log('%c Cargando biblia ...', 'color: orange')

  new Litepicker({
    element: document.getElementById("date-range"),
    singleMode: false,
    format: 'YYYY-MM-DD',
    autoApply: true,
    lang: "es",
    startDate: dateFns.format(new Date(), "yyyy-MM-dd"),
    endDate: dateFns.format(new Date(), "yyyy-MM-dd")
  })

  const formatDateISO = (dateISO) => {
    const date = new Date(dateISO);

    // Obtener los valores directamente en UTC
    const day = String(date.getUTCDate()).padStart(2, '0');
    const month = String(date.getUTCMonth() + 1).padStart(2, '0'); // Meses van de 0-11
    const year = date.getUTCFullYear();
    const hours = String(date.getUTCHours()).padStart(2, '0');
    const minutes = String(date.getUTCMinutes()).padStart(2, '0');

    return `${day}/${month}/${year} ${hours}:${minutes}`;
  };

  /**
   * old code 
   */

  const URI_API = '/api/bibles'
  const $formFilter = $('#formBibleFilter')

  $formFilter.on('submit', event => {
    event.preventDefault()
    const daterange = $formFilter.find("#date-range").val()
    console.log(daterange)
    // $table.bootstrapTable('refresh', {
    //   url: `${URI_API}?nombre=${search}`
    // })
  })

  const $tableBiblePackageDetailIn = $('#tableBiblePackageDetailIn')

  $tableBiblePackageDetailIn.bootstrapTable({
    url: `${URI_API}/in`,
    pagination: false,
    search: false,
    // nombre_pax, pax, de - via (servicios), hora, hotel, s./p (tipo), trasladista, O/S, movilidad, O/S, endose, observaciones, registra
    columns: [
      { field: 'paquete.nombre', title: 'Grupo / nombre' },
      {  field: 'paquete.cliente.razon_social', title: 'Cliente' },
      {  field: 'paquete.pax', title: 'Pax' },
      {  field: 'servicio.nombre', title: 'de / via' },
      {  field: 'fecha_hora', title: 'Fecha / hora', formatter: formatDateISO },
      { field: 'paquete.hotel.nombre', title: 'Hotel' },
      {  field: 'observacion', title: 'Observaciones' },
      {  field: 'paquete.usuario.nombre', title: 'Registrado por' },
    ],
    responseHandler: response => {
      console.log(response)
      return {
        total: response.length ?? 0,
        rows: response
      }
    }
  })

  const $tableBiblePackageDetailExc = $('#tableBiblePackageDetailExc')

  $tableBiblePackageDetailExc.bootstrapTable({
    url: `${URI_API}/exc`,
    pagination: false,
    search: false,
    // nombre_pax, pax, de - via (servicios), hora, hotel, s./p (tipo), trasladista, O/S, movilidad, O/S, endose, observaciones, registra
    columns: [
      { field: 'paquete.nombre', title: 'Grupo / nombre' },
      {  field: 'paquete.cliente.razon_social', title: 'Cliente' },
      {  field: 'paquete.pax', title: 'Pax' },
      {  field: 'servicio.nombre', title: 'de / via' },
      {  field: 'fecha_hora', title: 'Fecha / hora', formatter: formatDateISO },
      { field: 'paquete.hotel.nombre', title: 'Hotel' },
      {  field: 'observacion', title: 'Observaciones' },
      {  field: 'paquete.usuario.nombre', title: 'Registrado por' },
    ],
    responseHandler: response => {
      return {
        total: response.length ?? 0,
        rows: response
      }
    }
  })
  
  const $tableBiblePackageDetailOut = $('#tableBiblePackageDetailOut')

  $tableBiblePackageDetailOut.bootstrapTable({
    url: `${URI_API}/out`,
    pagination: false,
    search: false,
    // nombre_pax, pax, de - via (servicios), hora, hotel, s./p (tipo), trasladista, O/S, movilidad, O/S, endose, observaciones, registra
    columns: [
      { field: 'paquete.nombre', title: 'Grupo / nombre' },
      {  field: 'paquete.cliente.razon_social', title: 'Cliente' },
      {  field: 'paquete.pax', title: 'Pax' },
      {  field: 'servicio.nombre', title: 'de / via' },
      {  field: 'fecha_hora', title: 'Fecha / hora', formatter: formatDateISO },
      { field: 'paquete.hotel.nombre', title: 'Hotel' },
      {  field: 'observacion', title: 'Observaciones' },
      {  field: 'paquete.usuario.nombre', title: 'Registrado por' },
    ],
    responseHandler: response => {
      return {
        total: response.length ?? 0,
        rows: response
      }
    }
  })




/*
  const $tablePackage = $('#tablePackage')
  const $tablePackageIn = $('#tablePackageIn')
  const $tablePackageOut = $('#tablePackageOut')

  $tablePackageIn.bootstrapTable({
    url: URI_API,
    pagination: true,
    search: false,
    columns: [
      { field: 'nombre', title: 'nombre del paquete', sortable: true },
      { field: 'pax', title: 'pax', sortable: true },
      { field: 'pais.nombre', title: 'pais', sortable: true },
      { field: 'cliente.razon_social', title: 'cliente', sortable: true },
      { field: 'fecha_entrada', title: 'fecha de entrada', sortable: true, formatter: (d) => d.split('T').at(0) },
      { field: 'fecha_salida', title: 'fecha de salida', sortable: true, formatter: (d) => d.split('T').at(0) },
      { field: 'moneda.nombre', title: 'moneda', sortable: true },
      { field: 'total', title: 'total', sortable: true }, 
      { field: 'usuario.nombre', title: 'usuario', sortable: true },
      { field: 'created_at', title: 'fecha de creación', sortable: true, formatter: formatDate },
      { field: 'updated_at', title: 'fecha de actualización', sortable: true, formatter: formatDate },
    ],
    responseHandler: response => {
      console.log(response)

      const data = response.map((row, index) => ({
        ...row,
        key: response.length - index
      }))
      return {
        total: 0,
        rows: []
      }
      return {
        total: data.length ?? 0,
        rows: data
      }
    }
  })

  $tablePackage.bootstrapTable({
    url: URI_API,
    pagination: true,
    search: false,
    columns: [
      { field: 'nombre', title: 'nombre del paquete', sortable: true },
      { field: 'pax', title: 'pax', sortable: true },
      { field: 'pais.nombre', title: 'pais', sortable: true },
      { field: 'cliente.razon_social', title: 'cliente', sortable: true },
      { field: 'fecha_entrada', title: 'fecha de entrada', sortable: true, formatter: (d) => d.split('T').at(0) },
      { field: 'fecha_salida', title: 'fecha de salida', sortable: true, formatter: (d) => d.split('T').at(0) },
      { field: 'moneda.nombre', title: 'moneda', sortable: true },
      { field: 'total', title: 'total', sortable: true }, 
      { field: 'usuario.nombre', title: 'usuario', sortable: true },
      { field: 'created_at', title: 'fecha de creación', sortable: true, formatter: formatDate },
      { field: 'updated_at', title: 'fecha de actualización', sortable: true, formatter: formatDate },
    ],
    responseHandler: response => {
      console.log(response)

      const data = response.map((row, index) => ({
        ...row,
        key: response.length - index
      }))
      return {
        total: data.length ?? 0,
        rows: data
      }
    }
  })

  $tablePackageOut.bootstrapTable({
    url: URI_API,
    pagination: true,
    search: false,
    columns: [
      { field: 'nombre', title: 'nombre del paquete', sortable: true },
      { field: 'pax', title: 'pax', sortable: true },
      { field: 'pais.nombre', title: 'pais', sortable: true },
      { field: 'cliente.razon_social', title: 'cliente', sortable: true },
      { field: 'fecha_entrada', title: 'fecha de entrada', sortable: true, formatter: (d) => d.split('T').at(0) },
      { field: 'fecha_salida', title: 'fecha de salida', sortable: true, formatter: (d) => d.split('T').at(0) },
      { field: 'moneda.nombre', title: 'moneda', sortable: true },
      { field: 'total', title: 'total', sortable: true }, 
      { field: 'usuario.nombre', title: 'usuario', sortable: true },
      { field: 'created_at', title: 'fecha de creación', sortable: true, formatter: formatDate },
      { field: 'updated_at', title: 'fecha de actualización', sortable: true, formatter: formatDate },
    ],
    responseHandler: response => {
      console.log(response)

      const data = response.map((row, index) => ({
        ...row,
        key: response.length - index
      }))
      return {
        total: 0,
        rows: []
      }
      return {
        total: data.length ?? 0,
        rows: data
      }
    }
  })

  $formFilter.on('submit', event => {
    event.preventDefault()
    const search = $formFilter.find('#search').val()
    $table.bootstrapTable('refresh', {
      url: `${URI_API}?nombre=${search}`
    })
  })

  $modal.on('show.bs.modal', event => {
    const id = event.relatedTarget.dataset.id ?? 0

    if (id !== 0) {
      $form.find('#titleModal').text('Actualizar país')
      $.ajax({
        url: `${URI_API}/${id}`,
        type: method.get,
        success: function (data) {
          $form.find('#nombre').val(data.nombre)
          $form.find('#abreviatura').val(data.abreviatura)
          $form.find('#idioma').val(data.idioma)
          $form.attr('method', method.put)
          $form.attr('action', `${URI_API}/${data.id}`)
        }
      })
    } else {
      $form.find('#titleModal').text('Agregar país')
      $form.attr('method', method.post)
      $form.attr('action', URI_API)
    }
  })

  $form.on('submit', event => {
    event.preventDefault()
    const formData = new FormData(event.target)
    const data = Object.fromEntries(formData.entries())

    $.ajax({
      url: $form.attr('action'),
      type: $form.attr('method'),
      contentType: 'application/json',
      data: JSON.stringify(data),
      success: function () {
        $table.bootstrapTable('refresh', { url: URI_API })
        $modal.modal('hide')
      }
    })
  })

  $modalDelete.on('show.bs.modal', event => {
    const id = event.relatedTarget.dataset.id ?? 0
    $formDelete.attr('action', `${URI_API}/${id}`)
  })

  $formDelete.on('submit', event => {
    event.preventDefault()
    $.ajax({
      url: $formDelete.attr('action'),
      type: method.delete,
      contentType: 'application/json',
      success: function () {
        $table.bootstrapTable('refresh', { url: URI_API })
        $modalDelete.modal('hide')
      }
    })
  })

  $modal.on('hidden.bs.modal', () => $form[0].reset())
  $modalDelete.on('hidden.bs.modal', () => $formDelete[0].reset())
  */
})
