<?php

namespace App\Controller;

use App\Repository\PackageDetailRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Serializer\Normalizer\AbstractNormalizer;
use Symfony\Component\Serializer\SerializerInterface;
use Symfony\Component\Validator\Validator\ValidatorInterface;

final class BibleController extends AbstractController
{
    private $em;
    private $validator;
    private $serializer;

    public function __construct(EntityManagerInterface $em, ValidatorInterface $validator, SerializerInterface $serializer)
    {
        $this->em = $em;
        $this->validator = $validator;
        $this->serializer = $serializer;
    }

    # Render template package - paquetes
    #[Route('/biblia', name: 'bibles.index', methods:['GET'])]   
    public function index(): Response
    {
        return $this->render('bible/index.html.twig');
    }

    # GET /api/bibles/in
    #[Route('/api/bibles/in', name: 'api.bibles.in', methods: ['GET'])]
    public function in(Request $request, PackageDetailRepository $repo): JsonResponse
    {
        $packageDetails = $repo->findByServiceType('in');

        return $this->json(
            data: $packageDetails,
            status: Response::HTTP_OK,
            context: [AbstractNormalizer::GROUPS => ['packageDetail:read']]
        );
    }

    # GET /api/bibles/exc
    #[Route('/api/bibles/exc', name: 'api.bibles.exc', methods: ['GET'])]
    public function exc(Request $request, PackageDetailRepository $repo): JsonResponse
    {
        $packageDetails = $repo->findByServiceType('exc');

        return $this->json(
            data: $packageDetails,
            status: Response::HTTP_OK,
            context: [AbstractNormalizer::GROUPS => ['packageDetail:read']]
        );
    }

    # GET /api/bibles/out
    #[Route('/api/bibles/out', name: 'api.bibles.out', methods: ['GET'])]
    public function out(Request $request, PackageDetailRepository $repo): JsonResponse
    {
        $packageDetails = $repo->findByServiceType('out');

        return $this->json(
            data: $packageDetails,
            status: Response::HTTP_OK,
            context: [AbstractNormalizer::GROUPS => ['packageDetail:read']]
        );
    }
}
