<?php

namespace App\Controller;

use App\Entity\TypeDocument;
use App\Repository\AgencyRepository;
use App\Repository\TypeDocumentRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Serializer\Normalizer\AbstractNormalizer;
use Symfony\Component\Serializer\SerializerInterface;
use Symfony\Component\Validator\Validator\ValidatorInterface;

final class TypeDocumentController extends AbstractController
{
    private $em;
    private $validator;
    private $serializer;

    public function __construct(EntityManagerInterface $em, ValidatorInterface $validator, SerializerInterface $serializer)
    {
        $this->em = $em;
        $this->validator = $validator;
        $this->serializer = $serializer;
    }

    # Render template
    #[Route('/tipos-de-documento', name: 'type_documents.index', methods:['GET'])] 
    public function index(): Response
    {
        return $this->render('type_document/index.html.twig');
    }

    # GET /api/type_documents
    #[Route('/api/type_documents', name: 'api.type_documents.list', methods: ['GET'])]
    public function list(Request $request, TypeDocumentRepository $repo): JsonResponse
    {
        $nombre = $request->query->get('nombre');
        $type_documents = ($nombre) ? $repo->findByNombre($nombre) : $repo->findAll();

        return $this->json(
            data: $type_documents,
            status: Response::HTTP_OK,
            context: [AbstractNormalizer::GROUPS => ['typeDocument:read']]
        );
    }

    # GET /api/type_documents/:id
    #[Route('/api/type_documents/{id}', name: 'api.type_documents.show', methods: ['GET'])]
    public function show(TypeDocument $type_document): JsonResponse
    {
        return $this->json(
            data: $type_document,
            status: Response::HTTP_OK,
            context: [AbstractNormalizer::GROUPS => ['typeDocument:read']]
        );
    }

    # POST /api/type_documents
    #[Route('/api/type_documents', name: 'api.type_documents.create', methods: ['POST'])]
    public function create(Request $request): JsonResponse
    {
        $data = $request->getContent();
        $type_document = $this->serializer->deserialize($data, TypeDocument::class, 'json');
        $this->em->persist($type_document);
        $this->em->flush();

        return $this->json(
            data: $type_document,
            status: Response::HTTP_CREATED,
            context: [AbstractNormalizer::GROUPS => ['typeDocument:read']]
        );
    }

    # PUT /api/type_documents/:id
    #[Route('/api/type_documents/{id}', name: 'api.type_documents.update', methods: ['PUT'])]
    public function update(Request $request, TypeDocument $type_document): JsonResponse
    {
        if (!$type_document) return $this->json([]); # por si no existe el usuario

        $data = $request->getContent();
        $this->serializer->deserialize($data, TypeDocument::class, 'json', [AbstractNormalizer::OBJECT_TO_POPULATE => $type_document]);
        $this->em->flush();

        return $this->json(
            data: $type_document,
            status: Response::HTTP_OK,
            context: [AbstractNormalizer::GROUPS => ['typeDocument:read']]
        );
    }
}
