<?php

namespace App\Entity;

use App\Repository\PackageRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\Groups;

#[ORM\Entity(repositoryClass: PackageRepository::class)]
#[ORM\Table(name: 'paquetes')]
#[ORM\HasLifecycleCallbacks]
class Package
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    #[Groups(['package:read'])]
    private ?int $id = null;

    #[ORM\Column(length: 100)]
    #[Groups(['package:read', 'package:write', 'packageDetail:read'])]
    private ?string $nombre = null;

    #[ORM\Column(length: 8)]
    #[Groups(['package:read', 'package:write'])]
    private ?string $numero = null;

    #[ORM\ManyToOne]
    #[ORM\JoinColumn(nullable: false)]
    #[Groups(['package:read', 'package:write', 'packageDetail:read'])]
    private ?Client $cliente = null;

    #[ORM\ManyToOne]
    #[ORM\JoinColumn(nullable: false)]
    #[Groups(['package:read', 'package:write', 'packageDetail:read'])]
    private ?User $usuario = null;

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2)]
    #[Groups(['package:read', 'package:write'])]
    private ?string $subtotal = '0.00';

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2)]
    #[Groups(['package:read', 'package:write'])]
    private ?string $igv = '0.00';

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2)]
    #[Groups(['package:read', 'package:write'])]
    private ?string $total = '0.00';

    #[ORM\ManyToOne]
    #[ORM\JoinColumn(nullable: false)]
    #[Groups(['package:read', 'package:write'])]
    private ?TypeCurrency $moneda = null;

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2)]
    #[Groups(['package:read', 'package:write'])]
    private ?string $cobrado = '0.00';

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2)]
    #[Groups(['package:read', 'package:write'])]
    private ?string $saldo = '0.00';

    #[ORM\Column]
    #[Groups(['package:read', 'package:write'])]
    private ?bool $es_cobrado = false;

    #[ORM\Column(type: Types::DATE_MUTABLE)]
    #[Groups(['package:read', 'package:write'])]
    private ?\DateTimeInterface $fecha_entrada = null;

    #[ORM\Column(type: Types::DATE_MUTABLE)]
    #[Groups(['package:read', 'package:write'])]
    private ?\DateTimeInterface $fecha_salida = null;

    #[ORM\ManyToOne]
    #[ORM\JoinColumn(nullable: false)]
    #[Groups(['package:read', 'package:write'])]
    private ?Country $pais = null;

    #[ORM\Column]
    #[Groups(['package:read', 'package:write', 'packageDetail:read'])]
    private ?string $pax = null;

    #[ORM\ManyToOne]
    #[ORM\JoinColumn(nullable: true)]
    #[Groups(['package:read', 'package:write', 'packageDetail:read'])]
    private ?Hotel $hotel = null;

    #[ORM\Column(type: Types::DATETIMETZ_IMMUTABLE)]
    #[Groups(['package:read'])]
    private ?\DateTimeImmutable $created_at = null;

    #[ORM\Column(type: Types::DATETIMETZ_MUTABLE, nullable: true)]
    #[Groups(['package:read', 'package:write'])]
    private ?\DateTimeInterface $updated_at = null;

    /**
     * @var Collection<int, PackageDetail>
     */
    #[ORM\OneToMany(targetEntity: PackageDetail::class, mappedBy: 'paquete', cascade: ['persist', 'remove'])]
    #[Groups(['package:read', 'package:write'])]
    private Collection $packageDetails;

    public function __construct()
    {
        $this->packageDetails = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNombre(): ?string
    {
        return $this->nombre;
    }

    public function setNombre(string $nombre): static
    {
        $this->nombre = $nombre;

        return $this;
    }

    public function getNumero(): ?string
    {
        return $this->numero;
    }

    public function setNumero(string $numero): static
    {
        $this->numero = $numero;

        return $this;
    }

    public function getCliente(): ?Client
    {
        return $this->cliente;
    }

    public function setCliente(?Client $cliente): static
    {
        $this->cliente = $cliente;

        return $this;
    }

    public function getUsuario(): ?User
    {
        return $this->usuario;
    }

    public function setUsuario(?User $usuario): static
    {
        $this->usuario = $usuario;

        return $this;
    }

    public function getSubtotal(): ?string
    {
        return $this->subtotal;
    }

    public function setSubtotal(string $subtotal): static
    {
        $this->subtotal = $subtotal;

        return $this;
    }

    public function getIgv(): ?string
    {
        return $this->igv;
    }

    public function setIgv(string $igv): static
    {
        $this->igv = $igv;

        return $this;
    }

    public function getTotal(): ?string
    {
        return $this->total;
    }

    public function setTotal(string $total): static
    {
        $this->total = $total;

        return $this;
    }

    public function getMoneda(): ?TypeCurrency
    {
        return $this->moneda;
    }

    public function setMoneda(?TypeCurrency $moneda): static
    {
        $this->moneda = $moneda;

        return $this;
    }

    public function getCobrado(): ?string
    {
        return $this->cobrado;
    }

    public function setCobrado(string $cobrado): static
    {
        $this->cobrado = $cobrado;

        return $this;
    }

    public function getSaldo(): ?string
    {
        return $this->saldo;
    }

    public function setSaldo(string $saldo): static
    {
        $this->saldo = $saldo;

        return $this;
    }

    public function isEsCobrado(): ?bool
    {
        return $this->es_cobrado;
    }

    public function setEsCobrado(bool $es_cobrado): static
    {
        $this->es_cobrado = $es_cobrado;

        return $this;
    }

    public function getFechaEntrada(): ?\DateTimeInterface
    {
        return $this->fecha_entrada;
    }

    public function setFechaEntrada(\DateTimeInterface $fecha_entrada): static
    {
        $this->fecha_entrada = $fecha_entrada;

        return $this;
    }

    public function getFechaSalida(): ?\DateTimeInterface
    {
        return $this->fecha_salida;
    }

    public function setFechaSalida(\DateTimeInterface $fecha_salida): static
    {
        $this->fecha_salida = $fecha_salida;

        return $this;
    }

    public function getPais(): ?Country
    {
        return $this->pais;
    }

    public function setPais(?Country $pais): static
    {
        $this->pais = $pais;

        return $this;
    }

    public function getPax(): ?string
    {
        return $this->pax;
    }

    public function setPax(string $pax): static
    {
        $this->pax = $pax;

        return $this;
    }

    public function getHotel(): ?Hotel
    {
        return $this->hotel;
    }

    public function setHotel(?Hotel $hotel): static
    {
        $this->hotel = $hotel;

        return $this;
    }

    public function getCreatedAt(): ?\DateTimeImmutable
    {
        return $this->created_at;
    }

    public function setCreatedAt(\DateTimeImmutable $created_at): static
    {
        $this->created_at = $created_at;

        return $this;
    }

    public function getUpdatedAt(): ?\DateTimeInterface
    {
        return $this->updated_at;
    }

    public function setUpdatedAt(?\DateTimeInterface $updated_at): static
    {
        $this->updated_at = $updated_at;

        return $this;
    }

    #[ORM\PrePersist]
    public function prePersist(): void
    {
        $this->created_at = new \DateTimeImmutable();
    }

    #[ORM\PreUpdate]
    public function preUpdate(): void
    {
        $this->updated_at = new \DateTime();
    }

    /**
     * @return Collection<int, PackageDetail>
     */
    public function getPackageDetails(): Collection
    {
        return $this->packageDetails;
    }

    public function addPackageDetail(PackageDetail $packageDetail): static
    {
        if (!$this->packageDetails->contains($packageDetail)) {
            $this->packageDetails->add($packageDetail);
            $packageDetail->setPaquete($this);
        }

        return $this;
    }

    public function removePackageDetail(PackageDetail $packageDetail): static
    {
        if ($this->packageDetails->removeElement($packageDetail)) {
            // set the owning side to null (unless already changed)
            if ($packageDetail->getPaquete() === $this) {
                $packageDetail->setPaquete(null);
            }
        }

        return $this;
    }
}
