<?php

namespace App\Entity;

use App\Enum\TypeCharge;
use App\Enum\TypePackageDetail;
use App\Enum\TypeService;
use App\Repository\PackageDetailRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\Groups;

#[ORM\Entity(repositoryClass: PackageDetailRepository::class)]
#[ORM\Table(name: 'paquetes_detalles')]
#[ORM\HasLifecycleCallbacks]
class PackageDetail
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    #[Groups(['packageDetail:read', 'package:read'])]
    private ?int $id = null;

    #[ORM\ManyToOne(inversedBy: 'packageDetails')]
    #[ORM\JoinColumn(nullable: false)]
    #[Groups(['packageDetail:read', 'packageDetail:write'])]
    private ?Package $paquete = null;
    
    #[ORM\ManyToOne]
    #[ORM\JoinColumn(nullable: false)]
    #[Groups(['packageDetail:read', 'packageDetail:write', 'package:read'])]
    private ?Service $servicio = null;

    #[ORM\Column(type: Types::DATETIMETZ_MUTABLE)]
    #[Groups(['packageDetail:read', 'packageDetail:write', 'package:read'])]
    private ?\DateTimeInterface $fecha_hora = null;

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2)]
    #[Groups(['packageDetail:read', 'packageDetail:write', 'package:read'])]
    private ?string $precio = '0.00';

    #[ORM\Column]
    #[Groups(['packageDetail:read', 'packageDetail:write', 'package:read'])]
    private ?int $pax = null;

    #[ORM\Column(enumType: TypeCharge::class)]
    #[Groups(['packageDetail:read', 'packageDetail:write', 'package:read'])]
    private ?TypeCharge $tipo_cobro = TypeCharge::TOTAL;

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2)]
    #[Groups(['packageDetail:read', 'packageDetail:write', 'package:read'])]
    private ?string $total = '0.00';

    #[ORM\Column(length: 255, nullable: true)]
    #[Groups(['packageDetail:read', 'packageDetail:write', 'package:read'])]
    private ?string $observacion = '';

    #[ORM\Column(enumType: TypePackageDetail::class)]
    #[Groups(['packageDetail:read', 'packageDetail:write', 'package:read'])]
    private ?TypePackageDetail $tipo_servicio = TypePackageDetail::PRIVADO;

    #[ORM\Column(type: Types::DATETIMETZ_IMMUTABLE)]
    #[Groups(['packageDetail:read'])]
    private ?\DateTimeImmutable $created_at = null;

    #[ORM\Column(type: Types::DATETIMETZ_MUTABLE, nullable: true)]
    #[Groups(['packageDetail:read', 'packageDetail:write'])]
    private ?\DateTimeInterface $updated_at = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getPaquete(): ?Package
    {
        return $this->paquete;
    }

    public function setPaquete(?Package $paquete): static
    {
        $this->paquete = $paquete;

        return $this;
    }

    public function getServicio(): ?Service
    {
        return $this->servicio;
    }

    public function setServicio(?Service $servicio): static
    {
        $this->servicio = $servicio;

        return $this;
    }

    public function getFechaHora(): ?\DateTimeInterface
    {
        return $this->fecha_hora;
    }

    public function setFechaHora(\DateTimeInterface $fecha_hora): static
    {
        $this->fecha_hora = $fecha_hora;

        return $this;
    }

    public function getPrecio(): ?string
    {
        return $this->precio;
    }

    public function setPrecio(string $precio): static
    {
        $this->precio = $precio;

        return $this;
    }

    public function getPax(): ?int
    {
        return $this->pax;
    }

    public function setPax(int $pax): static
    {
        $this->pax = $pax;

        return $this;
    }

    public function getTipoCobro(): ?TypeCharge
    {
        return $this->tipo_cobro;
    }

    public function setTipoCobro(TypeCharge $tipo_cobro): static
    {
        $this->tipo_cobro = $tipo_cobro;

        return $this;
    }

    public function getTotal(): ?string
    {
        return $this->total;
    }

    public function setTotal(string $total): static
    {
        $this->total = $total;

        return $this;
    }

    public function getObservacion(): ?string
    {
        return $this->observacion;
    }

    public function setObservacion(string $observacion): static
    {
        $this->observacion = $observacion;

        return $this;
    }

    public function getTipoServicio(): ?TypePackageDetail
    {
        return $this->tipo_servicio;
    }

    public function setTipoServicio(TypePackageDetail $tipo_servicio): static
    {
        $this->tipo_servicio = $tipo_servicio;

        return $this;
    }

    public function getCreatedAt(): ?\DateTimeImmutable
    {
        return $this->created_at;
    }
    
    public function setCreatedAt(\DateTimeImmutable $created_at): static
    {
        $this->created_at = $created_at;

        return $this;
    }

    public function getUpdatedAt(): ?\DateTimeInterface
    {
        return $this->updated_at;
    }

    public function setUpdatedAt(?\DateTimeInterface $updated_at): static
    {
        $this->updated_at = $updated_at;

        return $this;
    }

    #[ORM\PrePersist]
    public function prePersist(): void
    {
        $this->created_at = new \DateTimeImmutable();
    }

    #[ORM\PreUpdate]
    public function preUpdate(): void
    {
        $this->updated_at = new \DateTime();
    }
}
