<?php

namespace App\Service;

use Dompdf\Dompdf;
use Dompdf\Options;
use Symfony\Component\HttpKernel\KernelInterface;
use Twig\Environment;

class PdfGenerator
{
    private string $projectDir;
    private Environment $twig;

    public function __construct(KernelInterface $kernel, Environment $twig)
    {
        $this->projectDir = $kernel->getProjectDir();
        $this->twig = $twig;
    }

    /**
     * Generar un PDF a partir de un template de Twig y datos dinámicos.
     *
     * @param string $template El nombre del template Twig (ej. "pdf/package.html.twig")
     * @param array $data Los datos que se inyectarán en el template
     * @param string $filename Nombre del archivo PDF (sin ruta)
     * @return string Ruta del archivo generado
     */
    public function generatePdf(string $template, array $data): string
    {
        $options = new Options();
        $options->set('isRemoteEnabled', true); # true para usar recursos remotos
        
        $html = $this->twig->render($template, $data);
        
        $dompdf = new Dompdf($options);
        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'portrait');
        $dompdf->render();

        // $pdfPath = "/public/pdfs/{$filename}";
        // file_put_contents($this->projectDir . $pdfPath, $dompdf->output());
        // return $pdfPath;

        return $dompdf->output();
    }
}
