<?php

namespace App\Controller;

use App\Entity\ServiceOrder;
use App\Repository\ServiceOrderRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Serializer\Normalizer\AbstractNormalizer;
use Symfony\Component\Serializer\SerializerInterface;
use Symfony\Component\Validator\Validator\ValidatorInterface;

final class ServiceOrderController extends AbstractController
{
    private $em;
    private $validator;
    private $serializer;

    public function __construct(EntityManagerInterface $em, ValidatorInterface $validator, SerializerInterface $serializer)
    {
        $this->em = $em;
        $this->validator = $validator;
        $this->serializer = $serializer;
    }

    # Render template countries - paises
    #[Route('/ordenes-de-servicio', name: 'service_orders.index', methods:['GET'])]   
    public function index(): Response
    {
        return $this->render('service_order/index.html.twig');
    }

    # GET /api/service_orders
    #[Route('/api/service_orders', name: 'api.service_orders.list', methods: ['GET'])]
    public function list(Request $request, ServiceOrderRepository $repo): JsonResponse
    {
        $nombre = $request->query->get('nombre');
        $serviceOrders = ($nombre) ? $repo->findByNombre($nombre) : $repo->findAll();

        return $this->json(
            data: $serviceOrders,
            status: Response::HTTP_OK,
            context: [AbstractNormalizer::GROUPS => ['serviceOrder:read']] 
        );
    }

    # GET /api/service_orders/:id
    #[Route('/api/service_orders/{id}', name: 'api.service_orders.show', methods: ['GET'])] 
    public function show(ServiceOrder $serviceOrder): JsonResponse
    {
        return $this->json(
            data: $serviceOrder,
            status: Response::HTTP_OK,
            context: [AbstractNormalizer::GROUPS => ['serviceOrder:read']]
        );
    }

    # POST /api/service_orders
    #[Route('/api/service_orders', name: 'api.service_orders.create', methods: ['POST'])]  
    public function create(Request $request): JsonResponse
    {
        $data = $request->getContent();
        $serviceOrder = $this->serializer->deserialize($data, ServiceOrder::class, 'json');
        $this->em->persist($serviceOrder);
        $this->em->flush();

        return $this->json(
            data: $serviceOrder,
            status: Response::HTTP_CREATED,
            context: [AbstractNormalizer::GROUPS => ['serviceOrder:read']]
        );
    }

    # PUT /api/service_orders/:id
    #[Route('/api/service_orders/{id}', name: 'api.service_orders.update', methods: ['PUT'])]
    public function update(Request $request, ServiceOrder $serviceOrder): JsonResponse
    {
        if (!$serviceOrder) return $this->json([]); # por si no existe

        $data = $request->getContent();
        $this->serializer->deserialize($data, ServiceOrder::class, 'json', [AbstractNormalizer::OBJECT_TO_POPULATE => $serviceOrder]);
        $this->em->flush();

        return $this->json(
            data: $serviceOrder,
            status: Response::HTTP_OK,
            context: [AbstractNormalizer::GROUPS => ['country:read']]
        );
    }
}
