<?php

namespace App\Entity;

use App\Repository\ServiceOrderGroupRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: ServiceOrderGroupRepository::class)]
#[ORM\Table(name: 'orden_servicio_grupo')]

class ServiceOrderGroup
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $observacion = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $es_igv = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $es_pagado_soles = null;

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2, nullable: true)]
    private ?string $pagado_soles = null;

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2, nullable: true)]
    private ?string $subtotal_soles = null;

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2, nullable: true)]
    private ?string $igv_soles = null;

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2)]
    private ?string $total_soles = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $es_pagado_dolares = null;

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2, nullable: true)]
    private ?string $pagado_dolares = null;

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2, nullable: true)]
    private ?string $subtotal_dolares = null;

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2, nullable: true)]
    private ?string $igv_dolares = null;

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2)]
    private ?string $total_dolares = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getObservacion(): ?string
    {
        return $this->observacion;
    }

    public function setObservacion(string $observacion): static
    {
        $this->observacion = $observacion;

        return $this;
    }

    public function getEsIgv(): ?string
    {
        return $this->es_igv;
    }

    public function setEsIgv(?string $es_igv): static
    {
        $this->es_igv = $es_igv;

        return $this;
    }

    public function getEsPagadoSoles(): ?string
    {
        return $this->es_pagado_soles;
    }

    public function setEsPagadoSoles(?string $es_pagado_soles): static
    {
        $this->es_pagado_soles = $es_pagado_soles;

        return $this;
    }

    public function getPagadoSoles(): ?string
    {
        return $this->pagado_soles;
    }

    public function setPagadoSoles(?string $pagado_soles): static
    {
        $this->pagado_soles = $pagado_soles;

        return $this;
    }

    public function getSubtotalSoles(): ?string
    {
        return $this->subtotal_soles;
    }

    public function setSubtotalSoles(?string $subtotal_soles): static
    {
        $this->subtotal_soles = $subtotal_soles;

        return $this;
    }

    public function getIgvSoles(): ?string
    {
        return $this->igv_soles;
    }

    public function setIgvSoles(?string $igv_soles): static
    {
        $this->igv_soles = $igv_soles;

        return $this;
    }

    public function getTotalSoles(): ?string
    {
        return $this->total_soles;
    }

    public function setTotalSoles(string $total_soles): static
    {
        $this->total_soles = $total_soles;

        return $this;
    }

    public function getEsPagadoDolares(): ?string
    {
        return $this->es_pagado_dolares;
    }

    public function setEsPagadoDolares(?string $es_pagado_dolares): static
    {
        $this->es_pagado_dolares = $es_pagado_dolares;

        return $this;
    }

    public function getPagadoDolares(): ?string
    {
        return $this->pagado_dolares;
    }

    public function setPagadoDolares(?string $pagado_dolares): static
    {
        $this->pagado_dolares = $pagado_dolares;

        return $this;
    }

    public function getSubtotalDolares(): ?string
    {
        return $this->subtotal_dolares;
    }

    public function setSubtotalDolares(?string $subtotal_dolares): static
    {
        $this->subtotal_dolares = $subtotal_dolares;

        return $this;
    }

    public function getIgvDolares(): ?string
    {
        return $this->igv_dolares;
    }

    public function setIgvDolares(?string $igv_dolares): static
    {
        $this->igv_dolares = $igv_dolares;

        return $this;
    }

    public function getTotalDolares(): ?string
    {
        return $this->total_dolares;
    }

    public function setTotalDolares(string $total_dolares): static
    {
        $this->total_dolares = $total_dolares;

        return $this;
    }
}
