<?php

namespace App\Entity;

use App\Repository\TypeCurrencyRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\Groups;

#[ORM\Entity(repositoryClass: TypeCurrencyRepository::class)]
#[ORM\Table(name: 'tipos_monedas')]
#[ORM\HasLifecycleCallbacks]
class TypeCurrency
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    #[Groups(['typeCurrency:read', 'package:read'])]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    #[Groups(['typeCurrency:read', 'typeCurrency:write', 'package:read'])]
    private ?string $nombre = null;

    #[ORM\Column(length: 255)]
    #[Groups(['typeCurrency:read', 'typeCurrency:write', 'package:read'])]
    private ?string $simbolo = null;

    #[ORM\Column(length: 255)]
    #[Groups(['typeCurrency:read', 'typeCurrency:write'])]
    private ?string $sigla = null;

    #[ORM\Column(type: Types::DATETIMETZ_IMMUTABLE)]
    #[Groups(['typeCurrency:read'])]
    private ?\DateTimeImmutable $created_at = null;

    #[ORM\Column(type: Types::DATETIMETZ_MUTABLE, nullable: true)]
    #[Groups(['typeCurrency:read', 'typeCurrency:write'])]
    private ?\DateTimeInterface $updated_at = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNombre(): ?string
    {
        return $this->nombre;
    }

    public function setNombre(?string $nombre): static
    {
        $this->nombre = $nombre;

        return $this;
    }

    public function getSimbolo(): ?string
    {
        return $this->simbolo;
    }

    public function setSimbolo(?string $simbolo): static
    {
        $this->simbolo = $simbolo;

        return $this;
    }

    public function getSigla(): ?string
    {
        return $this->sigla;
    }

    public function setSigla(string $sigla): static
    {
        $this->sigla = $sigla;

        return $this;
    }

    public function getCreatedAt(): ?\DateTimeImmutable
    {
        return $this->created_at;
    }

    public function setCreatedAt(\DateTimeImmutable $created_at): static
    {
        $this->created_at = $created_at;

        return $this;
    }

    public function getUpdatedAt(): ?\DateTimeInterface
    {
        return $this->updated_at;
    }

    public function setUpdatedAt(?\DateTimeInterface $updated_at): static
    {
        $this->updated_at = $updated_at;

        return $this;
    }

    #[ORM\PrePersist]
    public function prePersist(): void
    {
        $this->created_at = new \DateTimeImmutable();
    }

    #[ORM\PreUpdate]
    public function preUpdate(): void
    {
        $this->updated_at = new \DateTime();
    }
}
