$(document).ready(function () {
  console.log('%c Cargando paquetes ...', 'color: orange')

  const buttonsTable = (_, row) => {
    return `
      <div class="dropdown">
        <button class="text-dark" data-bs-toggle="dropdown" aria-label="Open actions" aria-expanded="true">
          ${iconAction}
        </button>
        <div class="dropdown-menu p-0 dropdown-menu-arrow">
          <a href="/paquetes/archivo/${row.id}/" target="_blank" class="dropdown-item gap-2">
            <i class="ph-fill ph-file-pdf"></i> archivo
          </a>
          <!--
          <a href="/paquetes/guardar/${row.id}" class="dropdown-item gap-2" data-id="${row.id}">
            <i class="ph-fill ph-pen"></i> Editar
          </a>
          <button class="dropdown-item gap-2" data-id="${row.id}" data-bs-toggle="modal" data-bs-target="#modalCountryDelete">
            <i class="ph-fill ph-trash-simple"></i> Eliminar
          </button>
          -->
        </div>
      </div>
    `
  }

  const URI_API = '/api/packages'
  const $table = $('#tablePackage')
  const $modal = $("#modalPackage")
  const $form = $('#formPackage')
  const $formFilter = $('#formPackageFilter')
  const $formDelete = $('#formPackageDelete')
  const $modalDelete = $('#modalPackageDelete')

  const formatServices = (detalles) => {
    const servicios = detalles.map(d => {
      const fecha = d.fecha_hora.split('T').at(0).split('-').reverse().join('/')
      return `<span class="d-block">${fecha} - ${d.servicio.nombre}</span>`
    }).join('')
    
    return servicios
  }

  $table.bootstrapTable({
    url: URI_API,
    pagination: true,
    search: false,
    columns: [
      { field: 'options', formatter: buttonsTable },
      { field: 'nombre', title: 'nombre del paquete', sortable: true },
      { field: 'package_details', title: 'servicios', sortable: true, formatter: formatServices },
      { field: 'pax', title: 'pax', sortable: true },
      { field: 'pais.nombre', title: 'pais', sortable: true },
      { field: 'cliente.razon_social', title: 'cliente', sortable: true },
      { field: 'fecha_entrada', title: 'fecha de entrada', sortable: true, formatter: (d) => d.split('T').at(0) },
      { field: 'fecha_salida', title: 'fecha de salida', sortable: true, formatter: (d) => d.split('T').at(0) },
      { field: 'moneda.nombre', title: 'moneda', sortable: true },
      { field: 'total', title: 'total', sortable: true }, 
      { field: 'usuario.nombre', title: 'usuario', sortable: true },
      { field: 'created_at', title: 'fecha de creación', sortable: true, formatter: formatDate },
      { field: 'updated_at', title: 'fecha de actualización', sortable: true, formatter: formatDate },
    ],
    responseHandler: response => {
      const data = response.map((row, index) => ({
        ...row,
        key: response.length - index
      }))
      return {
        total: data.length ?? 0,
        rows: data
      }
    }
  })

  $formFilter.on('submit', event => {
    event.preventDefault()
    const search = $formFilter.find('#search').val()
    $table.bootstrapTable('refresh', {
      url: `${URI_API}?nombre=${search}`
    })
  })

  $modal.on('show.bs.modal', event => {
    const id = event.relatedTarget.dataset.id ?? 0

    if (id !== 0) {
      $form.find('#titleModal').text('Actualizar país')
      $.ajax({
        url: `${URI_API}/${id}`,
        type: method.get,
        success: function (data) {
          $form.find('#nombre').val(data.nombre)
          $form.find('#abreviatura').val(data.abreviatura)
          $form.find('#idioma').val(data.idioma)
          $form.attr('method', method.put)
          $form.attr('action', `${URI_API}/${data.id}`)
        }
      })
    } else {
      $form.find('#titleModal').text('Agregar país')
      $form.attr('method', method.post)
      $form.attr('action', URI_API)
    }
  })

  $form.on('submit', event => {
    event.preventDefault()
    const formData = new FormData(event.target)
    const data = Object.fromEntries(formData.entries())

    $.ajax({
      url: $form.attr('action'),
      type: $form.attr('method'),
      contentType: 'application/json',
      data: JSON.stringify(data),
      success: function () {
        $table.bootstrapTable('refresh', { url: URI_API })
        $modal.modal('hide')
      }
    })
  })

  $modalDelete.on('show.bs.modal', event => {
    const id = event.relatedTarget.dataset.id ?? 0
    $formDelete.attr('action', `${URI_API}/${id}`)
  })

  $formDelete.on('submit', event => {
    event.preventDefault()
    $.ajax({
      url: $formDelete.attr('action'),
      type: method.delete,
      contentType: 'application/json',
      success: function () {
        $table.bootstrapTable('refresh', { url: URI_API })
        $modalDelete.modal('hide')
      }
    })
  })

  $modal.on('hidden.bs.modal', () => $form[0].reset())
  $modalDelete.on('hidden.bs.modal', () => $formDelete[0].reset())
})
