$(document).ready(function () {
  console.log('%c Cargando tipos de documento ...', 'color: orange')

  const buttonsTable = (_, row) => {
    return `
      <div class="dropdown">
        <button class="text-dark" data-bs-toggle="dropdown" aria-label="Open actions" aria-expanded="true">
          ${iconAction}
        </button>
        <div class="dropdown-menu p-0 dropdown-menu-arrow">
          <button class="dropdown-item gap-1" data-id="${row.id}" data-bs-toggle="modal" data-bs-target="#modalTypeDocument">
            <i class="ph-fill ph-pen"></i> Editar
          </button>
            <button class="dropdown-item gap-1" data-id="${row.id}" data-bs-toggle="modal" data-bs-target="#modalTypeDocumentDelete">
            <i class="ph-fill ph-trash-simple"></i> Eliminar
          </button>
        </div>
      </div>
    `
  }

  const URI_API = '/api/type_documents'
  const $table = $('#tableTypeDocument')
  const $modal = $("#modalTypeDocument")
  const $form = $('#formTypeDocument')
  const $formFilter = $('#formTypeDocumentFilter')
  const $formDelete = $('#formTypeDocumentDelete')
  const $modalDelete = $('#modalTypeDocumentDelete')

  $table.bootstrapTable({
    url: URI_API,
    pagination: true,
    search: false,
    columns: [
      { field: 'options', formatter: buttonsTable },
      { field: 'id', title: 'id', sortable: true },
      { field: 'nombre', title: 'nombre', sortable: true },
      { field: 'sigla', title: 'sigla', sortable: true },
      { field: 'codigo_sunat', title: 'codigo sunat', sortable: true },
      { field: 'created_at', title: 'fecha de creación', sortable: true, formatter: formatDate },
      { field: 'updated_at', title: 'fecha de actualización', sortable: true, formatter: formatDate },
    ],
    responseHandler: response => {
      const data = response.map((row, index) => ({
        ...row,
        key: response.length - index
      }))
      return {
        total: data.length ?? 0,
        rows: data
      }
    }
  })

  $formFilter.on('submit', event => {
    event.preventDefault()
    const search = $formFilter.find('#search').val()
    $table.bootstrapTable('refresh', {
      url: `${URI_API}?nombre=${search}`
    })
  })

  $modal.on('show.bs.modal', event => {
    const id = event.relatedTarget.dataset.id ?? 0

    if (id !== 0) {
      $form.find('#titleModal').text('Actualizar tipo de documento')
      $.ajax({
        url: `${URI_API}/${id}`,
        type: method.get,
        success: function (data) {
          $form.find('#nombre').val(data.nombre)
          $form.find('#sigla').val(data.sigla)
          $form.find('#codigo_sunat').val(data.codigo_sunat)
          $form.attr('method', method.put)
          $form.attr('action', `${URI_API}/${data.id}`)
        }
      })
    } else {
      $form.find('#titleModal').text('Agregar tipo de documento')
      $form.attr('method', method.post)
      $form.attr('action', URI_API)
    }
  })

  $form.on('submit', event => {
    event.preventDefault()
    const formData = new FormData(event.target)
    const data = Object.fromEntries(formData.entries())

    $.ajax({
      url: $form.attr('action'),
      type: $form.attr('method'),
      contentType: 'application/json',
      data: JSON.stringify(data),
      success: function () {
        $table.bootstrapTable('refresh', { url: URI_API })
        $modal.modal('hide')
      }
    })
  })

  $modalDelete.on('show.bs.modal', event => {
    const id = event.relatedTarget.dataset.id ?? 0
    $formDelete.attr('action', `${URI_API}/${id}`)
  })

  $formDelete.on('submit', event => {
    event.preventDefault()
    $.ajax({
      url: $formDelete.attr('action'),
      type: method.delete,
      contentType: 'application/json',
      success: function () {
        $table.bootstrapTable('refresh', { url: URI_API })
        $modalDelete.modal('hide')
      }
    })
  })

  $modal.on('hidden.bs.modal', () => $form[0].reset())
  $modalDelete.on('hidden.bs.modal', () => $formDelete[0].reset())
})
