<?php

namespace App\Controller;

use App\Entity\TypeProvider;
use App\Repository\TypeProviderRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Serializer\Normalizer\AbstractNormalizer;
use Symfony\Component\Serializer\SerializerInterface;
use Symfony\Component\Validator\Validator\ValidatorInterface;

final class TypeProviderController extends AbstractController
{
    private $em;
    private $validator;
    private $serializer;

    public function __construct(EntityManagerInterface $em, ValidatorInterface $validator, SerializerInterface $serializer)
    {
        $this->em = $em;
        $this->validator = $validator;
        $this->serializer = $serializer;
    }

    # Render template
    #[Route('/tipos-de-proveedor', name: 'type_providers.index', methods:['GET'])]
    public function index(): Response
    {
        return $this->render('type_provider/index.html.twig');
    }

    # GET /api/type_providers
    #[Route('/api/type_providers', name: 'api.type_providers.list', methods: ['GET'])]
    public function list(Request $request, TypeProviderRepository $repo): JsonResponse
    {
        $nombre = $request->query->get('nombre');
        $type_providers = ($nombre) ? $repo->findByNombre($nombre) : $repo->findAll();

        return $this->json(
            data: $type_providers,
            status: Response::HTTP_OK,
            context: [AbstractNormalizer::GROUPS => ['typeProvider:read']]
        );
    }

    # GET /api/type_providers/:id
    #[Route('/api/type_providers/{id}', name: 'api.type_providers.show', methods: ['GET'])]
    public function show(TypeProvider $typeProvider): JsonResponse
    {
        return $this->json(
            data: $typeProvider,
            status: Response::HTTP_OK,
            context: [AbstractNormalizer::GROUPS => ['typeProvider:read']]
        );
    }

    # POST /api/type_providers
    #[Route('/api/type_providers', name: 'api.type_providers.create', methods: ['POST'])]
    public function create(Request $request): JsonResponse
    {
        $data = $request->getContent();
        $typeProvider = $this->serializer->deserialize($data, TypeProvider::class, 'json');
        $this->em->persist($typeProvider);
        $this->em->flush();

        return $this->json(
            data: $typeProvider,
            status: Response::HTTP_CREATED,
            context: [AbstractNormalizer::GROUPS => ['typeProvider:read']]
        );
    }

    # PUT /api/type_providers/:id
    #[Route('/api/type_providers/{id}', name: 'api.type_providers.update', methods: ['PUT'])]
    public function update(Request $request, TypeProvider $typeProvider): JsonResponse
    {
        if (!$typeProvider) return $this->json([]); # por si no existe

        $data = $request->getContent();
        $this->serializer->deserialize($data, TypeProvider::class, 'json', [AbstractNormalizer::OBJECT_TO_POPULATE => $typeProvider]);
        $this->em->flush();

        return $this->json(
            data: $typeProvider,
            status: Response::HTTP_OK,
            context: [AbstractNormalizer::GROUPS => ['typeProvider:read']]
        );
    }
}
